<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require __DIR__ . '/config/db.php';

// Pastikan user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$pdo = getPDO();
$success = '';
$error = '';

// === Simpan agenda baru ===
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $judul = trim($_POST['judul']);
    $tanggal = $_POST['tanggal'];
    $waktu_mulai = $_POST['waktu_mulai'];
    $waktu_selesai = $_POST['waktu_selesai'];
    $lokasi = trim($_POST['lokasi']);
    $tempat = trim($_POST['tempat']);
    $penyelenggara = trim($_POST['penyelenggara']);
    $jenis = $_POST['jenis'] ?? 'Rapat';
    $status = 'Draf';
    $dibuat_oleh = $_SESSION['user_id'];

    // Buat kode_agenda unik otomatis
    $kode_agenda = 'AGD-' . strtoupper(uniqid());
    // Buat link presensi otomatis
    $base_url = "https://agenda.iahn-gdepudja.ac.id"; // Ganti sesuai domain kamu
    $link_presensi = $base_url . "/presensi.php?kode=" . urlencode($kode_agenda);

    if ($judul && $tanggal && $waktu_mulai && $waktu_selesai) {
        $stmt = $pdo->prepare("INSERT INTO agenda 
            (kode_agenda, judul, jenis, tanggal, lokasi, waktu_mulai, waktu_selesai, tempat, penyelenggara, dibuat_oleh, status, link_presensi) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([
            $kode_agenda,
            $judul,
            $jenis,
            $tanggal,
            $lokasi,
            $waktu_mulai,
            $waktu_selesai,
            $tempat,
            $penyelenggara,
            $dibuat_oleh,
            $status,
            $link_presensi
        ]);
        $success = "Agenda berhasil ditambahkan. Link presensi sudah dibuat.";
    } else {
        $error = "Kolom judul, tanggal, waktu mulai, dan waktu selesai wajib diisi.";
    }
}

// === Ambil semua agenda ===
$stmt = $pdo->query("
    SELECT a.*, u.nama AS nama_pembuat 
    FROM agenda a
    LEFT JOIN users u ON a.dibuat_oleh = u.id
    ORDER BY tanggal DESC, waktu_mulai ASC
");
$agendas = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Agenda - Portal Agenda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container py-4">
    <h3 class="mb-3">📅 Agenda Kegiatan</h3>

    <?php if ($success): ?>
        <div class="alert alert-success"><?= htmlspecialchars($success) ?></div>
    <?php elseif ($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" class="card p-3 mb-4">
        <h5>Tambah Agenda Baru</h5>
        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Judul</label>
                <input type="text" name="judul" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Tanggal</label>
                <input type="date" name="tanggal" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Jenis Kegiatan</label>
                <select name="jenis" class="form-select">
                    <option value="Rapat">Rapat</option>
                    <option value="Koordinasi">Koordinasi</option>
                    <option value="Sosialisasi">Sosialisasi</option>
                    <option value="Pelatihan">Pelatihan</option>
                    <option value="Lainnya">Lainnya</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Waktu Mulai</label>
                <input type="time" name="waktu_mulai" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Waktu Selesai</label>
                <input type="time" name="waktu_selesai" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Lokasi</label>
                <input type="text" name="lokasi" class="form-control">
            </div>
            <div class="col-md-3">
                <label class="form-label">Tempat</label>
                <input type="text" name="tempat" class="form-control">
            </div>
            <div class="col-md-3">
                <label class="form-label">Penyelenggara</label>
                <input type="text" name="penyelenggara" class="form-control">
            </div>
        </div>
        <button type="submit" class="btn btn-primary mt-3">Simpan Agenda</button>
    </form>

    <div class="card p-3">
        <h5>Daftar Agenda</h5>
        <table class="table table-bordered mt-2 align-middle">
            <thead class="table-light">
                <tr>
                    <th>Tanggal</th>
                    <th>Judul</th>
                    <th>Jenis</th>
                    <th>Waktu</th>
                    <th>Lokasi</th>
                    <th>Tempat</th>
                    <th>Penyelenggara</th>
                    <th>Dibuat oleh</th>
                    <th>Status</th>
                    <th>Link Presensi</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($agendas as $a): ?>
                    <tr>
                        <td><?= htmlspecialchars($a['tanggal']) ?></td>
                        <td><?= htmlspecialchars($a['judul']) ?></td>
                        <td><?= htmlspecialchars($a['jenis']) ?></td>
                        <td><?= htmlspecialchars($a['waktu_mulai']) ?> - <?= htmlspecialchars($a['waktu_selesai']) ?></td>
                        <td><?= htmlspecialchars($a['lokasi']) ?></td>
                        <td><?= htmlspecialchars($a['tempat'] ?: '-') ?></td>
                        <td><?= htmlspecialchars($a['penyelenggara'] ?: '-') ?></td>
                        <td><?= htmlspecialchars($a['nama_pembuat'] ?: $a['dibuat_oleh']) ?></td>
                        <td><?= htmlspecialchars($a['status']) ?></td>
                        <td>
                            <?php if (!empty($a['link_presensi'])): ?>
                                <a href="<?= htmlspecialchars($a['link_presensi']) ?>" target="_blank" class="btn btn-sm btn-success">Buka</a>
                                <button class="btn btn-sm btn-outline-secondary" onclick="copyLink('<?= htmlspecialchars($a['link_presensi']) ?>')">Copy</button>
                                <a href="rekap.php?kode=<?= htmlspecialchars($a['kode_agenda']) ?>" class="btn btn-sm btn-info">Rekap</a>

                            <?php else: ?>
                                <span class="text-muted">Belum ada</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
                <?php if (count($agendas) === 0): ?>
                    <tr><td colspan="10" class="text-center text-muted">Belum ada agenda.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function copyLink(link) {
    navigator.clipboard.writeText(link);
    alert("Link presensi berhasil disalin:\n" + link);
}
</script>
</body>
</html>
