<?php
session_start();
require __DIR__ . '/config/db.php';

// Koneksi ke database
$conn = getPDO();

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    // Cek user berdasarkan email
    $stmt = $conn->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Verifikasi password
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['nama'] = $user['nama'];
        $_SESSION['role'] = $user['role'];

        header('Location: dashboard.php');
        exit;
    } else {
        $error = 'Email atau password salah.';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login - Portal Agenda IAHN Gde Pudja Mataram</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f6f9;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            font-family: 'Segoe UI', sans-serif;
        }
        .login-card {
            background: #fff;
            padding: 30px;
            border-radius: 16px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 420px;
        }
        .login-card h4 {
            font-weight: 600;
        }
    </style>
</head>
<body>

<div class="login-card">
    <h4 class="text-center text-primary mb-3">🔐 Portal Agenda IAHN</h4>
    <p class="text-center text-muted mb-4">Masuk untuk melanjutkan</p>

    <?php if ($error): ?>
        <div class="alert alert-danger text-center py-2"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <label class="form-label">Email Institusi</label>
            <input type="email" name="email" class="form-control" placeholder="contoh@iahn-gdepudja.ac.id" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Kata Sandi</label>
            <input type="password" name="password" class="form-control" placeholder="••••••••" required>
        </div>

        <button type="submit" class="btn btn-primary w-100">Masuk</button>
    </form>

    <hr>
    <p class="text-center text-muted small mb-0">
        &copy; <?= date('Y') ?> IAHN Gde Pudja Mataram<br>
        <span class="text-secondary">Sistem Agenda & Kehadiran Rapat</span>
    </p>
</div>

</body>
</html>
