<?php
session_start();
require __DIR__ . '/config/db.php';

// Koneksi ke database
$conn = getPDO();

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['nama'] = $user['nama'];
        $_SESSION['role'] = $user['role'];

        header('Location: dashboard.php');
        exit;
    } else {
        $error = 'Email atau password salah.';
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Login - Digital Agenda IAHN Gde Pudja Mataram</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #004aad, #00b4d8);
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            font-family: 'Poppins', sans-serif;
            overflow: hidden;
        }

        .login-card {
            background: #fff;
            padding: 40px 35px;
            border-radius: 20px;
            box-shadow: 0 8px 24px rgba(0,0,0,0.15);
            width: 100%;
            max-width: 420px;
            animation: fadeIn 0.8s ease;
        }

        .login-logo {
            text-align: center;
            margin-bottom: 20px;
        }

        .login-logo img {
            width: 90px;
            height: 90px;
            object-fit: contain;
        }

        h4 {
            text-align: center;
            font-weight: 600;
            color: #004aad;
        }

        .form-label {
            font-weight: 500;
            color: #333;
        }

        .form-control {
            border-radius: 10px;
            padding: 10px 14px;
        }

        .btn-primary {
            background: #004aad;
            border: none;
            border-radius: 10px;
            font-weight: 500;
            padding: 10px;
            transition: all 0.2s ease;
        }

        .btn-primary:hover {
            background: #0066ff;
            transform: translateY(-1px);
        }

        .alert {
            font-size: 14px;
            border-radius: 10px;
        }

        hr {
            margin: 1.5rem 0;
        }

        footer {
            text-align: center;
            font-size: 13px;
            color: #777;
        }

        footer span {
            display: block;
            color: #555;
        }

        @keyframes fadeIn {
            from {opacity: 0; transform: translateY(15px);}
            to {opacity: 1; transform: translateY(0);}
        }

        @media (max-width: 576px) {
            .login-card {
                padding: 30px 25px;
                border-radius: 16px;
            }
        }
    </style>
</head>
<body>

<div class="login-card">
    <div class="login-logo">
        <img src="assets/logo-iahngdepudja.png" alt="Logo IAHN">
    </div>

    <h4>Portal Agenda IAHN</h4>
    <p class="text-center text-muted mb-4">Silakan login untuk melanjutkan</p>

    <?php if ($error): ?>
        <div class="alert alert-danger text-center py-2"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <label class="form-label">Email Institusi</label>
            <input type="email" name="email" class="form-control" placeholder="contoh@iahn-gdepudja.ac.id" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Kata Sandi</label>
            <input type="password" name="password" class="form-control" placeholder="••••••••" required>
        </div>

        <button type="submit" class="btn btn-primary w-100">Masuk</button>
    </form>

    <hr>
    <footer>
        &copy; <?= date('Y') ?> IAHN Gde Pudja Mataram
        <span>Sistem Agenda & Kehadiran Rapat</span>
    </footer>
</div>

</body>
</html>
