<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require __DIR__ . '/config/db.php';

$pdo = getPDO();
$success = '';
$error = '';
$agenda = null;

// Ambil kode agenda dari URL
$kode = $_GET['kode'] ?? '';

if (!$kode) {
    die("<div style='margin:2rem; font-family:sans-serif; color:red'>⚠️ Kode agenda tidak ditemukan.</div>");
}

// Ambil detail agenda
$stmt = $pdo->prepare("SELECT * FROM agenda WHERE kode_agenda = ?");
$stmt->execute([$kode]);
$agenda = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$agenda) {
    die("<div style='margin:2rem; font-family:sans-serif; color:red'>⚠️ Agenda dengan kode tersebut tidak ditemukan.</div>");
}

// 🔒 Cek status agenda
$status = $agenda['status'];
$tanggal_selesai = $agenda['tanggal_selesai'] ?? null;

// Jika status bukan "Aktif" atau tanggal sudah lewat, tampilkan pesan dan hentikan form
$is_locked = false;
$today = date('Y-m-d');

if ($status !== 'Aktif' || ($tanggal_selesai && $today > $tanggal_selesai)) {
    $is_locked = true;
}

// Simpan presensi (hanya jika tidak terkunci)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$is_locked) {
    $nama = trim($_POST['nama']);
    $jabatan = trim($_POST['jabatan']);
    $tanda_tangan = $_POST['tanda_tangan'];

    if ($nama && $tanda_tangan) {
        $stmt = $pdo->prepare("INSERT INTO presensi (kode_agenda, nama_peserta, jabatan, tanda_tangan) VALUES (?, ?, ?, ?)");
        $stmt->execute([$kode, $nama, $jabatan, $tanda_tangan]);
        $success = "✅ Presensi berhasil disimpan. Terima kasih sudah hadir!";
    } else {
        $error = "Nama dan tanda tangan wajib diisi.";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Presensi Kehadiran</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #f0f4f8, #e9eef3); font-family: "Segoe UI", sans-serif; }
        .card { border: none; border-radius: 16px; box-shadow: 0 4px 18px rgba(0, 0, 0, 0.08); }
        .card h4 { font-weight: 600; color: #0d6efd; }
        canvas { border: 2px dashed #ccc; width: 100%; height: 250px; border-radius: 8px; background-color: #fff; touch-action: none; }
        footer { text-align: center; margin-top: 1rem; color: #888; font-size: 0.85rem; }
    </style>
</head>
<body>
<div class="container py-4">
    <div class="card p-4">
        <h4 class="mb-3 text-center">📋 Presensi Kehadiran</h4>

        <div class="mb-3 text-muted small">
            <strong>Judul:</strong> <?= htmlspecialchars($agenda['judul']) ?><br>
            <strong>Tanggal:</strong> <?= htmlspecialchars($agenda['tanggal']) ?><br>
            <strong>Waktu:</strong> <?= htmlspecialchars($agenda['waktu_mulai']) ?> - <?= htmlspecialchars($agenda['waktu_selesai']) ?><br>
            <strong>Tempat:</strong> <?= htmlspecialchars($agenda['tempat'] ?: '-') ?><br>
            <strong>Penyelenggara:</strong> <?= htmlspecialchars($agenda['penyelenggara'] ?: '-') ?><br>
            <strong>Status Agenda:</strong> 
            <span class="badge bg-<?= $status === 'Aktif' ? 'success' : ($status === 'Selesai' ? 'secondary' : 'warning') ?>">
                <?= htmlspecialchars($status) ?>
            </span>
        </div>

        <?php if ($success): ?>
            <div class="alert alert-success text-center"><?= htmlspecialchars($success) ?></div>
        <?php elseif ($error): ?>
            <div class="alert alert-danger text-center"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <?php if ($is_locked): ?>
            <div class="alert alert-warning text-center">
                ⚠️ Presensi tidak dapat diisi karena status agenda 
                <strong><?= htmlspecialchars($status) ?></strong>
                <?= $status === 'Selesai' ? 'atau sudah melewati tanggal berakhir.' : '.' ?>
            </div>
        <?php else: ?>
        <!-- FORM PRESENSI -->
        <form method="POST" onsubmit="return prepareSignature()">
            <div class="mb-3">
                <label class="form-label">Nama Lengkap</label>
                <input type="text" name="nama" class="form-control" placeholder="Tuliskan nama Anda" required>
            </div>

            <div class="mb-3">
                <label class="form-label">Jabatan / Posisi</label>
                <input type="text" name="jabatan" class="form-control" placeholder="Contoh: Dosen, Mahasiswa, Panitia, dll">
            </div>

            <div class="mb-3">
                <label class="form-label">Tanda Tangan</label>
                <canvas id="signature-pad"></canvas>
                <div class="mt-2 d-flex justify-content-between">
                    <button type="button" class="btn btn-outline-secondary btn-sm" onclick="clearSignature()">🧽 Hapus</button>
                    <button type="submit" class="btn btn-primary btn-sm">📨 Kirim Presensi</button>
                </div>
                <input type="hidden" name="tanda_tangan" id="tanda_tangan">
            </div>
        </form>
        <?php endif; ?>
    </div>

    <footer>
        &copy; <?= date('Y') ?> IAHN Gde Pudja Mataram — Digital Agenda by UPT-TIPD
    </footer>
</div>

<script>
const canvas = document.getElementById('signature-pad');
if (canvas) {
    const ctx = canvas.getContext('2d');
    let drawing = false;

    function resizeCanvas() {
        const ratio = Math.max(window.devicePixelRatio || 1, 1);
        const data = canvas.toDataURL();
        canvas.width = canvas.offsetWidth * ratio;
        canvas.height = 250 * ratio;
        ctx.scale(ratio, ratio);
        ctx.lineWidth = 2;
        ctx.lineCap = 'round';
        const img = new Image();
        img.src = data;
        img.onload = () => ctx.drawImage(img, 0, 0);
    }
    window.addEventListener('resize', resizeCanvas);
    resizeCanvas();

    // Mouse
    canvas.addEventListener('mousedown', e => { drawing = true; ctx.beginPath(); ctx.moveTo(e.offsetX, e.offsetY); });
    canvas.addEventListener('mousemove', e => { if (drawing) { ctx.lineTo(e.offsetX, e.offsetY); ctx.stroke(); } });
    canvas.addEventListener('mouseup', () => drawing = false);
    canvas.addEventListener('mouseleave', () => drawing = false);

    // Touch
    canvas.addEventListener('touchstart', e => {
        e.preventDefault();
        drawing = true;
        const t = e.touches[0];
        const rect = canvas.getBoundingClientRect();
        ctx.beginPath();
        ctx.moveTo(t.clientX - rect.left, t.clientY - rect.top);
    });
    canvas.addEventListener('touchmove', e => {
        e.preventDefault();
        if (!drawing) return;
        const t = e.touches[0];
        const rect = canvas.getBoundingClientRect();
        ctx.lineTo(t.clientX - rect.left, t.clientY - rect.top);
        ctx.stroke();
    });
    canvas.addEventListener('touchend', () => drawing = false);

    function clearSignature() {
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }

    function prepareSignature() {
        const dataURL = canvas.toDataURL("image/png");
        if (dataURL.length < 1000) {
            alert("Silakan tanda tangan terlebih dahulu sebelum kirim.");
            return false;
        }
        document.getElementById('tanda_tangan').value = dataURL;
        return true;
    }
}
</script>
</body>
</html>
