<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
require __DIR__ . '/config/db.php';

$pdo = getPDO();
$kode = $_GET['kode'] ?? '';

if (!$kode) {
    die("<h3>Kode agenda tidak ditemukan.</h3>");
}

// Ambil detail agenda
$stmt = $pdo->prepare("SELECT * FROM agenda WHERE kode_agenda = ?");
$stmt->execute([$kode]);
$agenda = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$agenda) {
    die("<h3>Agenda tidak ditemukan.</h3>");
}

// Ambil daftar presensi
$stmt = $pdo->prepare("SELECT * FROM presensi WHERE kode_agenda = ? ORDER BY waktu_hadir ASC");
$stmt->execute([$kode]);
$presensi = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Rekap Presensi - <?= htmlspecialchars($agenda['judul']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: "Segoe UI", sans-serif;
        }
        .signature {
            border: 1px solid #ddd;
            border-radius: 4px;
            background-color: #fff;
            padding: 4px;
            text-align: center;
        }
        .signature img {
            width: auto;
            max-height: 80px;
            object-fit: contain;
        }
        table th {
            background-color: #e9ecef;
            text-align: center;
            vertical-align: middle;
        }
        table td {
            vertical-align: middle;
        }
        .card h5 {
            color: #0d6efd;
        }
    </style>
</head>
<body>
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4>📋 Rekap Presensi</h4>
        <a href="agenda.php" class="btn btn-secondary btn-sm">⬅ Kembali</a>
    </div>

    <div class="card p-3 mb-4 shadow-sm">
        <h5 class="mb-2"><?= htmlspecialchars($agenda['judul']) ?></h5>
        <p class="mb-1"><strong>Tanggal:</strong> <?= htmlspecialchars($agenda['tanggal']) ?></p>
        <p class="mb-1"><strong>Waktu:</strong> <?= htmlspecialchars($agenda['waktu_mulai']) ?> - <?= htmlspecialchars($agenda['waktu_selesai']) ?></p>
        <p class="mb-1"><strong>Tempat:</strong> <?= htmlspecialchars($agenda['tempat'] ?: '-') ?></p>
        <p class="mb-0"><strong>Penyelenggara:</strong> <?= htmlspecialchars($agenda['penyelenggara'] ?: '-') ?></p>
    </div>

    <div class="card p-3 shadow-sm">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h5 class="mb-0">Daftar Hadir Peserta</h5>
            <a href="rekap_pdf.php?kode=<?= urlencode($kode) ?>" target="_blank" class="btn btn-danger btn-sm">🖨️ Cetak PDF</a>
        </div>

        <?php if (count($presensi) > 0): ?>
            <div class="table-responsive">
                <table class="table table-bordered align-middle">
                    <thead class="table-light">
                        <tr>
                            <th width="5%">No</th>
                            <th>Nama Peserta</th>
                            <th>Jabatan / Posisi</th>
                            <th width="20%">Waktu Hadir</th>
                            <th width="25%">Tanda Tangan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($presensi as $i => $p): ?>
                            <tr>
                                <td class="text-center"><?= $i + 1 ?></td>
                                <td><?= htmlspecialchars($p['nama_peserta']) ?></td>
                                <td><?= htmlspecialchars($p['jabatan'] ?: '-') ?></td>
                                <td class="text-center"><?= htmlspecialchars($p['waktu_hadir']) ?></td>
                                <td class="signature">
                                    <img src="<?= htmlspecialchars($p['tanda_tangan']) ?>" alt="Tanda Tangan">
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="alert alert-warning text-center">Belum ada peserta yang mengisi presensi.</div>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
