<?php
require __DIR__ . '/config/db.php';
require_once __DIR__ . '/lib/fpdf.php';

$pdo = getPDO();
$kode = $_GET['kode'] ?? '';

if (!$kode) {
    die("Kode agenda tidak ditemukan.");
}

// Ambil data agenda
$stmt = $pdo->prepare("SELECT * FROM agenda WHERE kode_agenda = ?");
$stmt->execute([$kode]);
$agenda = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$agenda) {
    die("Agenda tidak ditemukan.");
}

// Ambil daftar presensi
$stmt = $pdo->prepare("SELECT * FROM presensi WHERE kode_agenda = ? ORDER BY waktu_hadir ASC");
$stmt->execute([$kode]);
$presensi = $stmt->fetchAll(PDO::FETCH_ASSOC);

/**
 * Hitung berapa baris teks untuk lebar tertentu
 */
function calcLines($pdf, $w, $txt) {
    $words = preg_split('/\s+/', trim($txt));
    $lines = 1;
    $current = '';
    foreach ($words as $word) {
        $test = ($current === '') ? $word : $current . ' ' . $word;
        if ($pdf->GetStringWidth($test) > $w) {
            $lines++;
            $current = $word;
        } else {
            $current = $test;
        }
    }
    return max(1, $lines);
}

$pdf = new FPDF('P', 'mm', 'A4');
$pdf->AddPage();
$pdf->SetAutoPageBreak(true, 20);

// === KOP SURAT ===
$kopPath = __DIR__ . '/assets/img/kop.png';
if (file_exists($kopPath)) {
    $pdf->Image($kopPath, 10, 8, 190);
    $pdf->Ln(36);
} else {
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 6, 'INSTITUT AGAMA HINDU NEGERI GDE PUJA MATARAM', 0, 1, 'C');
    $pdf->Cell(0, 6, 'Jl. Pancaka No.7, Mataram – Telp. (0370) xxxx', 0, 1, 'C');
    $pdf->Ln(8);
}

// === JUDUL DAN DETAIL AGENDA ===
$pdf->SetFont('Arial', 'B', 14);
$pdf->Cell(0, 8, 'DAFTAR HADIR RAPAT / KEGIATAN', 0, 1, 'C');
$pdf->Ln(4);

$pdf->SetFont('Arial', '', 11);
$pdf->Cell(30, 6, 'Judul', 0, 0);
$pdf->Cell(0, 6, ': ' . $agenda['judul'], 0, 1);
$pdf->Cell(30, 6, 'Tanggal', 0, 0);
$pdf->Cell(0, 6, ': ' . $agenda['tanggal'], 0, 1);
$pdf->Cell(30, 6, 'Waktu', 0, 0);
$pdf->Cell(0, 6, ': ' . $agenda['waktu_mulai'] . ' - ' . $agenda['waktu_selesai'], 0, 1);
$pdf->Cell(30, 6, 'Tempat', 0, 0);
$pdf->Cell(0, 6, ': ' . ($agenda['tempat'] ?: '-'), 0, 1);
$pdf->Cell(30, 6, 'Penyelenggara', 0, 0);
$pdf->Cell(0, 6, ': ' . ($agenda['penyelenggara'] ?: '-'), 0, 1);
$pdf->Ln(6);

// === TABEL PRESENSI (Tanpa Waktu Hadir) ===
$w_no = 10;
$w_name = 90;
$w_jabatan = 60;
$w_sig = 30;
$lineHeight = 5;

$pdf->SetFont('Arial', 'B', 11);
$pdf->SetFillColor(235, 235, 235);
$pdf->Cell($w_no, 10, 'No', 1, 0, 'C', true);
$pdf->Cell($w_name, 10, 'Nama Peserta', 1, 0, 'C', true);
$pdf->Cell($w_jabatan, 10, 'Jabatan', 1, 0, 'C', true);
$pdf->Cell($w_sig, 10, 'Tanda Tangan', 1, 1, 'C', true);

$pdf->SetFont('Arial', '', 10);
$no = 1;

foreach ($presensi as $p) {
    $txtName = $p['nama_peserta'] ?: '-';
    $txtJab = $p['jabatan'] ?? '-';

    $linesName = calcLines($pdf, $w_name - 4, $txtName);
    $linesJab = calcLines($pdf, $w_jabatan - 4, $txtJab);
    $maxLines = max($linesName, $linesJab);
    $rowH = $lineHeight * $maxLines + 10; // tinggi baris ditambah agar muat tanda tangan besar

    $startX = $pdf->GetX();
    $startY = $pdf->GetY();

    // Buat border tiap kolom
    $pdf->Rect($startX, $startY, $w_no, $rowH);
    $pdf->Rect($startX + $w_no, $startY, $w_name, $rowH);
    $pdf->Rect($startX + $w_no + $w_name, $startY, $w_jabatan, $rowH);
    $pdf->Rect($startX + $w_no + $w_name + $w_jabatan, $startY, $w_sig, $rowH);

    // Kolom No
    $pdf->SetXY($startX, $startY);
    $pdf->Cell($w_no, $rowH, $no++, 0, 0, 'C');

    // Kolom Nama
    $pdf->SetXY($startX + $w_no + 2, $startY + 3);
    $pdf->MultiCell($w_name - 4, $lineHeight, $txtName, 0, 'L');

    // Kolom Jabatan
    $pdf->SetXY($startX + $w_no + $w_name + 2, $startY + 3);
    $pdf->MultiCell($w_jabatan - 4, $lineHeight, $txtJab, 0, 'L');

    // Kolom Tanda Tangan
    $sigData = $p['tanda_tangan'] ?? '';
    $sigX = $startX + $w_no + $w_name + $w_jabatan;
    $sigY = $startY;

    if (strpos($sigData, 'data:image') === 0) {
        $img = preg_replace('#^data:image/\w+;base64,#i', '', $sigData);
        $tmp = tempnam(sys_get_temp_dir(), 'sig_pdf_') . '.png';
        file_put_contents($tmp, base64_decode($img));
        list($iw, $ih) = getimagesize($tmp);

        if ($iw > 0 && $ih > 0) {
            // Perbesar tanda tangan agar tampak jelas
            $maxW = $w_sig - 4;          // lebar maksimum dalam kolom
            $maxH = min($rowH - 4, 22);  // tinggi maksimum
            $scale = min($maxW / $iw, $maxH / $ih) * 1.5; // diperbesar 1.5x
            $drawW = $iw * $scale;
            $drawH = $ih * $scale;

            // Tengah-tengah posisi gambar dalam kolom
            $drawX = $sigX + ($w_sig - $drawW) / 2;
            $drawY = $sigY + ($rowH - $drawH) / 2;

            $pdf->Image($tmp, $drawX, $drawY, $drawW, $drawH);
        }
        @unlink($tmp);
    } else {
        $pdf->SetXY($sigX, $sigY + ($rowH - $lineHeight) / 2);
        $pdf->Cell($w_sig, $lineHeight, '-', 0, 0, 'C');
    }

    $pdf->SetXY($startX, $startY + $rowH);
}

// === FOOTER ===
$pdf->Ln(8);
$pdf->SetFont('Arial', '', 11);
$pdf->Cell(0, 6, 'Mataram, ' . date('d F Y'), 0, 1, 'R');
$pdf->Ln(18);
$pdf->Cell(120, 6, '', 0, 0);
$pdf->Cell(60, 6, '_____________________', 0, 1, 'C');
$pdf->Cell(120, 6, '', 0, 0);
$pdf->Cell(60, 6, 'Pimpinan Rapat', 0, 1, 'C');

$pdf->Output('I', 'rekap-presensi-' . $agenda['kode_agenda'] . '.pdf');
?>
