<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require __DIR__ . '/config/db.php';

// Cek login dulu
if (!isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

$pdo = getPDO();

// Ambil parameter
$kode = $_GET['kode'] ?? '';
$status = $_GET['status'] ?? '';

if (!$kode || !$status) {
    die("<div style='margin:2rem; font-family:sans-serif; color:red'>⚠️ Parameter tidak lengkap.</div>");
}

// Validasi status yang diizinkan
$allowed = ['Draf', 'Aktif', 'Selesai'];
if (!in_array($status, $allowed)) {
    die("<div style='margin:2rem; font-family:sans-serif; color:red'>⚠️ Status tidak valid.</div>");
}

// Cek apakah agenda ada
$stmt = $pdo->prepare("SELECT * FROM agenda WHERE kode_agenda = ?");
$stmt->execute([$kode]);
$agenda = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$agenda) {
    die("<div style='margin:2rem; font-family:sans-serif; color:red'>⚠️ Agenda tidak ditemukan.</div>");
}

// Update status
if ($status === 'Selesai') {
    // Jika diset selesai, tambahkan tanggal_selesai otomatis hari ini
    $stmt = $pdo->prepare("UPDATE agenda SET status = ?, tanggal_selesai = CURDATE() WHERE kode_agenda = ?");
    $stmt->execute([$status, $kode]);
} else {
    // Kalau ke Draf atau Aktif, kosongkan tanggal_selesai
    $stmt = $pdo->prepare("UPDATE agenda SET status = ?, tanggal_selesai = NULL WHERE kode_agenda = ?");
    $stmt->execute([$status, $kode]);
}

// Redirect kembali ke halaman utama
header("Location: agenda.php");
exit;
